/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.EmulatorUILogic;
import jace.apple2e.MOS65C02;
import jace.core.Computer;
import jace.core.RAM;
import jace.hardware.massStorage.CardMassStorage;
import jace.hardware.massStorage.DirectoryNode;
import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.FreespaceBitmap;
import jace.hardware.massStorage.IDisk;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProdosVirtualDisk
implements IDisk {
    public static int VOLUME_START = 2;
    public static int FREESPACE_BITMAP_START = 6;
    byte[] ioBuffer = new byte[512];
    File physicalRoot;
    Map<Integer, DiskNode> physicalMap;
    DirectoryNode rootDirectory;
    FreespaceBitmap freespaceBitmap;

    public ProdosVirtualDisk(File rootPath) throws IOException {
        this.setPhysicalPath(rootPath);
    }

    @Override
    public void mliRead(int block, int bufferAddress) throws IOException {
        DiskNode node = this.physicalMap.get(block);
        RAM memory = Computer.getComputer().getMemory();
        Arrays.fill(this.ioBuffer, (byte)0);
        if (node == null) {
            System.out.println("Reading unknown block?!");
            for (int i = 0; i < 512; ++i) {
                memory.write(bufferAddress + i, (byte)0, false);
            }
        } else {
            node.readBlock(this.ioBuffer);
            for (int i = 0; i < 512; ++i) {
                memory.write(bufferAddress + i, this.ioBuffer[i], false);
            }
        }
    }

    @Override
    public void mliWrite(int block, int bufferAddress) throws IOException {
        System.out.println("Write block " + block + " to " + Integer.toHexString(bufferAddress));
        throw new IOException("Write not implemented yet!");
    }

    @Override
    public void mliFormat() {
        throw new UnsupportedOperationException("Formatting for this type of media is not supported!");
    }

    public File locateFile(File rootPath, String string) {
        File mostLikelyMatch = null;
        for (File f : rootPath.listFiles()) {
            if (f.getName().equalsIgnoreCase(string)) {
                return f;
            }
            if (!string.toUpperCase().startsWith(f.getName().toUpperCase()) || mostLikelyMatch != null && f.getName().length() <= mostLikelyMatch.getName().length()) continue;
            mostLikelyMatch = f;
        }
        return mostLikelyMatch;
    }

    public int getNextFreeBlock() throws IOException {
        for (int i = 2; i < 65535; ++i) {
            if (this.physicalMap.containsKey(i)) continue;
            return i;
        }
        throw new IOException("Virtual Disk Full!");
    }

    public void allocateEntry(DiskNode node) {
        this.physicalMap.put(node.baseBlock, node);
        for (DiskNode sub : node.additionalNodes) {
            this.physicalMap.put(sub.getBaseBlock(), sub);
        }
    }

    public void deallocateEntry(DiskNode node) {
        if (this.physicalMap.get(node.baseBlock) != null && this.physicalMap.get(node.baseBlock).equals(node)) {
            this.physicalMap.remove(node.baseBlock);
        }
        for (DiskNode sub : node.additionalNodes) {
            if (this.physicalMap.get(sub.getBaseBlock()) == null || !this.physicalMap.get(sub.baseBlock).equals(sub)) continue;
            this.physicalMap.remove(sub.getBaseBlock());
        }
    }

    public boolean isAllocated(int i) {
        return this.physicalMap.containsKey(i);
    }

    @Override
    public void boot0(int slot) throws IOException {
        File prodos = this.locateFile(this.physicalRoot, "PRODOS.SYS");
        if (prodos == null || !prodos.exists()) {
            throw new IOException("Unable to locate PRODOS.SYS");
        }
        Computer.getComputer().getCpu().suspend();
        byte slot16 = (byte)(slot << 4);
        ((MOS65C02)Computer.getComputer().getCpu()).X = slot16;
        RAM memory = Computer.getComputer().getMemory();
        memory.write(CardMassStorage.SLT16, slot16, false);
        memory.write(CardMassStorage.MLI_COMMAND, (byte)CardMassStorage.MLI_COMMAND_TYPE.READ.intValue, false);
        memory.write(CardMassStorage.MLI_UNITNUMBER, slot16, false);
        memory.writeWord(72, 49152 + CardMassStorage.DEVICE_DRIVER_OFFSET + slot * 256, false);
        EmulatorUILogic.brun(prodos, 8192);
        Computer.getComputer().getCpu().resume();
    }

    @Override
    public File getPhysicalPath() {
        return this.physicalRoot;
    }

    @Override
    public void setPhysicalPath(File f) throws IOException {
        if (this.physicalRoot != null && this.physicalRoot.equals(f)) {
            return;
        }
        this.physicalRoot = f;
        this.physicalMap = new HashMap<Integer, DiskNode>();
        if (!this.physicalRoot.exists() || !this.physicalRoot.isDirectory()) {
            try {
                throw new IOException("Root path must be a directory that exists!");
            }
            catch (IOException ex) {
                Logger.getLogger(ProdosVirtualDisk.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.rootDirectory = new DirectoryNode(this, this.physicalRoot, VOLUME_START);
        this.rootDirectory.setName("VIRTUAL");
        this.allocateEntry(this.rootDirectory);
        this.freespaceBitmap = new FreespaceBitmap(this, FREESPACE_BITMAP_START);
        this.allocateEntry(this.freespaceBitmap);
    }

    @Override
    public void eject() {
    }

    @Override
    public boolean isWriteProtected() {
        return true;
    }

    @Override
    public int getSize() {
        return 65535;
    }
}

